function TS_VIX = import_VIX(filename)
% --------------------------------------------------------------------------------------------------
% Import historical VIX index and store in TS object
% --------------------------------------------------------------------------------------------------
% sample call: data_bloomberg = import_VIX('c:/thesis/data/bloomberg/VIX.xls')
% --------------------------------------------------------------------------------------------------

% Import data
[num, txt] = xlsread(filename, 1, 'A4:B2000');
dates = datenum({txt{:,1}}');
values = num;

TS_VIX = struct('dates', dates, 'values', values);